//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "EditGridForm.h"
#include "IWCompEdit.hpp"
#include "IWCompButton.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MenuFrame"
#pragma link "IWBaseControl"
#pragma link "IWCompText"
#pragma link "IWControl"
#pragma link "IWGrids"
#pragma link "IWBaseHTMLControl"
#pragma link "IWVCLBaseControl"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
extern Currency FromCurrency(const AnsiString AText);
//---------------------------------------------------------------------------
__fastcall TformEditGrid::TformEditGrid(TComponent* Owner)
        : TIWAppForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TformEditGrid::IWAppFormCreate(TObject *Sender)
{
int i;
Currency LAmount;
TStringList *LFirstNames, *LLastNames;

  try {
    LLastNames = new TStringList();
    LLastNames->Add("Smith");
    LLastNames->Add("Green");
    LLastNames->Add("Jones");
    LLastNames->Add("Wagner");
    LLastNames->Add("Black");
    LLastNames->Add("Donner");
    LLastNames->Add("Bush");

    try {
      LFirstNames = new TStringList();
      LFirstNames->Add("John");
      LFirstNames->Add("Mary");
      LFirstNames->Add("Elena");
      LFirstNames->Add("Nancy");
      LFirstNames->Add("James");
      LFirstNames->Add("George");
      LFirstNames->Add("Daryl");
      LFirstNames->Add("Deborah");
      LFirstNames->Add("Erik");
      LFirstNames->Add("Leon");
      LFirstNames->Add("Bill");
      LFirstNames->Add("Dan");

      tablGrid->Cell[0][0]->Text = "Name";
      tablGrid->Cell[0][0]->Width= "200";
      tablGrid->Cell[0][1]->Text = "";
      tablGrid->Cell[0][1]->Width= "50";
      tablGrid->Cell[0][2]->Text = "Date";
      tablGrid->Cell[0][2]->Width= "60";
      tablGrid->Cell[0][3]->Text = "Amount";
      tablGrid->Cell[0][3]->Width= "60";

      for (i = 1; i<=tablGrid->RowCount - 2; i++)
       {
       tablGrid->Cell[i][0]->Clickable = true;
       tablGrid->Cell[i][0]->Text = LFirstNames->Strings[random(LFirstNames->Count)] + " "
                                    + LLastNames->Strings[random(LLastNames->Count)];

       tablGrid->Cell[i][1]->Text = "";
       tablGrid->Cell[i][2]->Alignment=taCenter;
       tablGrid->Cell[i][2]->Text = IntToStr(random(12) + 1) + "/" + IntToStr(random(29) + 1) + "/"
             + IntToStr(random(3) + 1999);
       tablGrid->Cell[i][3]->Alignment = taRightJustify;
       LAmount = random(200);
       if (random(4) == 0)
         LAmount = -LAmount;
       tablGrid->Cell[i][3]->Control = new TIWEdit(this);
       ((TIWEdit*)tablGrid->Cell[i][3]->Control)->Text = CurrToStr(LAmount);
       ((TIWEdit*)tablGrid->Cell[i][3]->Control)->Width = 75;
       }
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Alignment = taRightJustify;
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Clickable = true;
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Font->Style = TFontStyles()<<fsBold;

      Total();
      }
    __finally {
      //FreeAndNil(LFirstNames);
        delete LFirstNames;
        LFirstNames=NULL;
      }
    }
  __finally {
      //FreeAndNil(LLastNames);
      delete LLastNames;
      LLastNames=NULL;
    }
}
//---------------------------------------------------------------------------
void __fastcall TformEditGrid::tablGridCellClick(const int ARow,
      const int AColumn)
{
TIWButton *LButton;
TIWEdit *LEdit;

  if (AColumn == 0)
    {
    // Create an edit box
    LEdit = new TIWEdit(this);
    // Set the cell's control property
    tablGrid->Cell[ARow][AColumn]->Control = LEdit;
    // Get cell value
    LEdit->Text = tablGrid->Cell[ARow][AColumn]->Text;
    // Clear the cell text because the edit will display it.
    tablGrid->Cell[ARow][AColumn]->Text = "";

    LButton = new TIWButton(this);
    tablGrid->Cell[ARow][AColumn + 1]->Control = LButton;
    // Use the tag to record which row the button is in
    LButton->Tag = ARow;
    LButton->Caption = "Done";
    LButton->OnClick = UpdateNameClick;
    }
  else
    Total();
}
//---------------------------------------------------------------------------
void __fastcall TformEditGrid::tablGridRenderCell(TIWGridCell *ACell,
      const int ARow, const int AColumn)
{
  if (ARow == 0)
    {
    // Title Row
    ACell->BGColor = clBlue;
    ACell->Font->Style = TFontStyles()<<fsBold;
    }
  else if (ARow < tablGrid->RowCount - 1)
    {
    // Dont include the total row
    // Alternate Row Colors
    if (ARow % 2==0)
      ACell->BGColor = clLtGray;
    else
      ACell->BGColor = clNone;
    // Mark negative values as red
    if (AColumn == 3)
      if (FromCurrency(((TIWEdit*)ACell->Control)->Text) < 0)
        ACell->Font->Color = clRed;
    }
}
//---------------------------------------------------------------------------
void __fastcall TformEditGrid::Total()
{
int   i;
Currency LAmount, LTotal;
TIWEdit *LEdit;

  LTotal = 0;
  for (i = 1; i<=tablGrid->RowCount - 2; i++)
    {
    LEdit = (TIWEdit*)tablGrid->Cell[i][3]->Control;
    LAmount = FromCurrency(LEdit->Text);
    // Reformat it
    LEdit->Text = CurrToStr(LAmount);
    LTotal += LAmount;
    }
  if (LTotal < 0)
    tablGrid->Cell[tablGrid->RowCount - 1][3]->Font->Color = clRed;
  else
    tablGrid->Cell[tablGrid->RowCount - 1][3]->Font->Color = clBlue;
  tablGrid->Cell[tablGrid->RowCount - 1][3]->Text = CurrToStr(LTotal);
}
//---------------------------------------------------------------------------
void __fastcall TformEditGrid::UpdateNameClick(TObject *ASender)
{
TIWButton *LButton;
TIWEdit *LEdit;

  LButton = (TIWButton*)ASender;
  LEdit = (TIWEdit*)tablGrid->Cell[LButton->Tag][0]->Control;
  // Update and free edit
  tablGrid->Cell[LButton->Tag][0]->Text = LEdit->Text;
  tablGrid->Cell[LButton->Tag][0]->Control = NULL;
  delete LEdit;
  // Remove button
  tablGrid->Cell[LButton->Tag][1]->Control = NULL;
  delete LButton;
}
//---------------------------------------------------------------------------

